define("core/local/templates/loader",["exports","jquery","core/ajax","core/str","core/config","core/mustache","core/localstorage","core/utils"],(function(_exports,_jquery,_ajax,str,config,_mustache,_localstorage,_utils){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireWildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}
/**
   * Template this.
   *
   * @module     core/local/templates/loader
   * @copyright  2023 Andrew Lyons <andrew@nicols.co.uk>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   * @since      4.3
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_ajax=_interopRequireDefault(_ajax),str=_interopRequireWildcard(str),config=_interopRequireWildcard(config),_mustache=_interopRequireDefault(_mustache),_localstorage=_interopRequireDefault(_localstorage);class Loader{constructor(){_defineProperty(this,"currentThemeName","")}static getSearchKey(theme,templateName){return"".concat(theme,"/").concat(templateName)}static getTemplate(templateName){let themeName=arguments.length>1&&void 0!==arguments[1]?arguments[1]:config.theme;const searchKey=this.getSearchKey(themeName,templateName),cachedPromise=this.getTemplatePromiseFromCache(searchKey);if(cachedPromise)return cachedPromise;const existingBufferRecords=this.loadTemplateBuffer.filter((record=>record.searchKey===searchKey));if(existingBufferRecords.length)return existingBufferRecords[0].deferred.promise();const parts=templateName.split("/"),component=(0,_utils.getNormalisedComponent)(parts.shift()),name=parts.join("/"),deferred=_jquery.default.Deferred();return this.loadTemplateBuffer.push({component:component,name:name,theme:themeName,searchKey:searchKey,deferred:deferred}),this.processLoadTemplateBuffer(),deferred.promise()}static setTemplateInCache(searchKey,templateSource){this.templateCache.set(searchKey,templateSource)}static getTemplateFromCache(searchKey){return this.templateCache.get(searchKey)}static hasTemplateInCache(searchKey){return this.templateCache.has(searchKey)}static prefetchTemplates(templateNames,themeName){templateNames.forEach((templateName=>this.prefetchTemplate(templateName,themeName)))}static prefetchTemplate(templateName,themeName){const searchKey=this.getSearchKey(themeName,templateName);if(this.hasTemplateInCache(searchKey))return;if(this.loadTemplateBuffer.filter((record=>record.searchKey===searchKey)).length)return;const parts=templateName.split("/"),component=(0,_utils.getNormalisedComponent)(parts.shift()),name=parts.join("/");this.loadTemplateBuffer.push({component:component,name:name,theme:themeName,searchKey:searchKey,deferred:_jquery.default.Deferred()}),this.processLoadTemplateBuffer()}static partialHelper(name){let themeName=arguments.length>1&&void 0!==arguments[1]?arguments[1]:config.theme;const searchKey=this.getSearchKey(themeName,name);return this.hasTemplateInCache(searchKey)||new Error("Failed to pre-fetch the template: ".concat(name)),this.getTemplateFromCache(searchKey)}static scanForPartials(templateSource){const tokens=_mustache.default.parse(templateSource),partials=[],findPartial=(tokens,partials)=>{let i;for(i=0;i<tokens.length;i++){const token=tokens[i];">"!=token[0]&&"<"!=token[0]||partials.push(token[1]),token.length>4&&findPartial(token[4],partials)}};return findPartial(tokens,partials),partials}static cachePartials(templateName){let themeName=arguments.length>1&&void 0!==arguments[1]?arguments[1]:config.theme,parentage=arguments.length>2&&void 0!==arguments[2]?arguments[2]:[];const searchKey=this.getSearchKey(themeName,templateName);return searchKey in this.cachePartialPromises||(parentage.length||parentage.push(searchKey),this.cachePartialPromises[searchKey]=_jquery.default.Deferred(),this._cachePartials(templateName,themeName,parentage).catch((error=>{this.cachePartialPromises[searchKey].reject(error)}))),this.cachePartialPromises[searchKey]}static async _cachePartials(templateName,themeName,parentage){const searchKey=this.getSearchKey(themeName,templateName),templateSource=await this.getTemplate(templateName,themeName),fetchThemAll=this.scanForPartials(templateSource).filter((partialName=>!(parentage.indexOf("".concat(themeName,"/").concat(partialName))>=0)&&partialName!==templateName)).map((partialName=>(parentage.push("".concat(themeName,"/").concat(partialName)),this.cachePartials(partialName,themeName,parentage))));return await Promise.all(fetchThemAll),this.cachePartialPromises[searchKey].resolve(templateSource)}static processLoadTemplateBuffer(){if(!this.loadTemplateBuffer.length)return;if(this.isLoadingTemplates)return;this.isLoadingTemplates=!0;const templatesToLoad=this.loadTemplateBuffer.slice(),serverRequestsDeferred=_jquery.default.Deferred(),requests=[],templatePromises=templatesToLoad.map((templateData=>{const component=(0,_utils.getNormalisedComponent)(templateData.component),name=templateData.name,searchKey=templateData.searchKey,theme=templateData.theme,templateDeferred=templateData.deferred;let promise=null;if(this.hasTemplateInCache(searchKey))promise=this.getTemplatePromiseFromCache(searchKey);else{requests.push({methodname:"core_output_load_template_with_dependencies",args:{component:component,template:name,themename:theme,lang:config.language}});const index=requests.length-1;promise=serverRequestsDeferred.promise().then((promises=>(templatePromises[searchKey]=promises[index].then((response=>(response.templates.forEach((data=>{data.component=(0,_utils.getNormalisedComponent)(data.component);const tempSearchKey=this.getSearchKey(theme,[data.component,data.name].join("/"));this.setTemplateInCache(tempSearchKey,data.value),config.templaterev>0&&_localstorage.default.set("core_template/".concat(config.templaterev,":").concat(tempSearchKey),data.value)})),response.strings.length&&str.cache_strings(response.strings.map((_ref=>{let{component:component,name:name,value:value}=_ref;return{component:(0,_utils.getNormalisedComponent)(component),key:name,value:value}}))),this.hasTemplateInCache(searchKey)?this.getTemplateFromCache(searchKey):null))),templatePromises[searchKey])))}return promise.then((source=>templateDeferred.resolve(source))).catch((error=>{throw templateDeferred.reject(error),error}))}));requests.length?serverRequestsDeferred.resolve(_ajax.default.call(requests,!0,!1,!1,0,config.templaterev)):serverRequestsDeferred.resolve(),_jquery.default.when.apply(null,templatePromises).then((()=>{this.loadTemplateBuffer.splice(0,templatesToLoad.length),this.isLoadingTemplates=!1,this.processLoadTemplateBuffer()})).catch((()=>{this.loadTemplateBuffer.splice(0,templatesToLoad.length),this.isLoadingTemplates=!1,this.processLoadTemplateBuffer()}))}static getTemplatePromiseFromCache(searchKey){if(searchKey in this.templatePromises)return this.templatePromises[searchKey];if(this.hasTemplateInCache(searchKey)){const templateSource=this.getTemplateFromCache(searchKey);return this.templatePromises[searchKey]=_jquery.default.Deferred().resolve(templateSource).promise(),this.templatePromises[searchKey]}if(config.templaterev<=0)return null;const cached=_localstorage.default.get("core_template/".concat(config.templaterev,":").concat(searchKey));return cached?(this.setTemplateInCache(searchKey,cached),this.templatePromises[searchKey]=_jquery.default.Deferred().resolve(cached).promise(),this.templatePromises[searchKey]):null}}return _exports.default=Loader,_defineProperty(Loader,"loadTemplateBuffer",[]),_defineProperty(Loader,"isLoadingTemplates",!1),_defineProperty(Loader,"templateCache",new Map),_defineProperty(Loader,"templatePromises",{}),_defineProperty(Loader,"cachePartialPromises",[]),_exports.default}));

//# sourceMappingURL=loader.min.js.map